/*************************************************************************************/
/* Pprava situace																	 */
/*************************************************************************************/

USE SqlDevCon
DROP TABLE Data
GO

CREATE TABLE Data
(
	ZaznamID int  IDENTITY(1,1) NOT NULL,
	HodnotaID int,
	CONSTRAINT PK_Data PRIMARY KEY CLUSTERED (ZaznamID ASC) 
) ON [PRIMARY]
GO

-- Vzorov data
INSERT INTO Data(HodnotaID) VALUES(1)
INSERT INTO Data(HodnotaID) VALUES(2)
INSERT INTO Data(HodnotaID) VALUES(NULL)
GO

-- Vechny zznamy pro kontrolu
SELECT * FROM Data ORDER BY HodnotaID -- NULL je pi azen men ne hodnota



/*************************************************************************************/
/* Problm 1																		 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID <> 1
GO




/*************************************************************************************/
/* Problm 2																		 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID IN (1, 2, NULL)
GO




/*************************************************************************************/
/* Problm 3																		 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID NOT IN (2, 3, NULL)
GO




/*************************************************************************************/
/* Problm 4																		 */
/*************************************************************************************/

SELECT *
	FROM Data data1
		FULL JOIN Data data2 ON (data1.HodnotaID = data2.HodnotaID)
GO









/*************************************************************************************/
/* Chovn NULL																		 */
/*************************************************************************************/

IF (NULL IS NULL)
	PRINT 'Splnno'
ELSE
	PRINT 'Nesplnno'
GO


IF (NULL = NULL)
	PRINT 'Splnno'
ELSE
	PRINT 'Nesplnno'
GO

IF (NULL <> NULL)
	PRINT 'Splnno'
ELSE
	PRINT 'Nesplnno'
GO


IF (NULL != 10)
	PRINT 'Splnno'
ELSE
	PRINT 'Nesplnno'
GO

IF (NULL = 10)
	PRINT 'Splnno'
ELSE
	PRINT 'Nesplnno'
GO






/*************************************************************************************/
/* Problm 1 - een																 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID <> 1
GO

-- een
SELECT * FROM Data WHERE (HodnotaID <> 1) OR (HodnotaID IS NULL)
GO



/*************************************************************************************/
/* Problm 2 - een																 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID IN (1, 2, NULL)
GO

-- een
SELECT * FROM Data WHERE (HodnotaID IN (1, 2)) OR (HodnotaID IS NULL)



/*************************************************************************************/
/* Problm 3 - een																 */
/*************************************************************************************/

-- Problm
SELECT * FROM Data WHERE HodnotaID NOT IN (2, 3, NULL)
GO

-- een
SELECT * FROM Data WHERE (HodnotaID NOT IN (2,3)) AND (HodnotaID IS NOT NULL)
GO


/*************************************************************************************/
/* Problm 4 - een																 */
/*************************************************************************************/

SELECT *
	FROM Data data1
		FULL JOIN Data data2 ON (data1.HodnotaID = data2.HodnotaID)
GO

-- Obskurn een
SELECT *
	FROM Data data1
		FULL JOIN Data data2 ON (
									(data1.HodnotaID = data2.HodnotaID)
									OR
									((data1.HodnotaID IS NULL) AND (data2.HodnotaID IS NULL))
								)
GO
